<?php
/*--------------------------------------------------------------------
 ReadServiceInterface.php 2020-2-20
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitModel\Database\Service;

use Gambio\Shop\Attributes\SellingUnitModel\Database\Exceptions\OptionValueIdDoesNotExistsException;
use Gambio\Shop\Attributes\SellingUnitModel\Database\Repository\DTO\AttributesModelDto;
use Gambio\Shop\Attributes\SellingUnitModel\Database\Repository\DTO\OptionValuesIdDto;

/**
 * Interface ReadServiceInterface
 * @package Gambio\Shop\Attributes\SellingUnitModel\Database\Service
 */
interface ReadServiceInterface
{
    /**
     * @param OptionValuesIdDto $dto
     *
     * @return AttributesModelDto
     * @throws OptionValueIdDoesNotExistsException
     */
    public function attributeModelByOptionValuesId(OptionValuesIdDto $dto): AttributesModelDto;
}